<?php

namespace Specification\Akeneo\Pim\Enrichment\Component\Product\Connector\ArrayConverter\FlatToStandard;

use Akeneo\Pim\Structure\Component\Model\AssociationTypeInterface;
use Akeneo\Pim\Structure\Component\Repository\AssociationTypeRepositoryInterface;
use PhpSpec\ObjectBehavior;

class AssociationColumnsResolverSpec extends ObjectBehavior
{
    function let(AssociationTypeRepositoryInterface $assocTypeRepo)
    {
        $this->beConstructedWith($assocTypeRepo);
    }

    function it_resolves_association_type_field_names(
        $assocTypeRepo,
        AssociationTypeInterface $assocType1,
        AssociationTypeInterface $assocType2
    ) {
        $assocType1->getCode()->willReturn("ASSOC_TYPE_1");
        $assocType2->getCode()->willReturn("ASSOC_TYPE_2");
        $assocType1->isQuantified()->willReturn(false);
        $assocType2->isQuantified()->willReturn(false);
        $assocTypeRepo->findAll()->willReturn([$assocType1, $assocType2]);
        $this->resolveAssociationColumns()->shouldReturn(
            [
                "ASSOC_TYPE_1-groups",
                "ASSOC_TYPE_1-products",
                "ASSOC_TYPE_1-product_uuids",
                "ASSOC_TYPE_1-product_models",
                "ASSOC_TYPE_2-groups",
                "ASSOC_TYPE_2-products",
                "ASSOC_TYPE_2-product_uuids",
                "ASSOC_TYPE_2-product_models",
            ]
        );
    }

    function it_resolves_quantified_association_type_field_names(
        $assocTypeRepo,
        AssociationTypeInterface $assocType1,
        AssociationTypeInterface $assocType2
    ) {
        $assocType1->getCode()->willReturn("ASSOC_TYPE_1");
        $assocType2->getCode()->willReturn("ASSOC_TYPE_2");
        $assocType1->isQuantified()->willReturn(true);
        $assocType2->isQuantified()->willReturn(true);
        $assocTypeRepo->findAll()->willReturn([$assocType1, $assocType2]);
        $this->resolveQuantifiedAssociationColumns()->shouldReturn(
            [
                "ASSOC_TYPE_1-products",
                "ASSOC_TYPE_1-product_models",
                "ASSOC_TYPE_2-products",
                "ASSOC_TYPE_2-product_models",
                "ASSOC_TYPE_1-products-quantity",
                "ASSOC_TYPE_1-product_models-quantity",
                "ASSOC_TYPE_2-products-quantity",
                "ASSOC_TYPE_2-product_models-quantity",
            ]
        );
    }

    function it_caches_the_associations_even_without_results($assocTypeRepo)
    {
        $assocTypeRepo->findAll()->willReturn([])->shouldBeCalledTimes(1);
        $this->resolveAssociationColumns()->shouldReturn([]);
        $this->resolveAssociationColumns()->shouldReturn([]);
    }
}
