<?php

namespace Akeneo\Tool\Component\StorageUtils\Factory;

/**
 * Simple object factory
 *
 * @author    Julien Sanchez <julien@akeneo.com>
 * @copyright 2016 Akeneo SAS (http://www.akeneo.com)
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class SimpleFactory implements SimpleFactoryInterface
{
    /** @var string */
    protected $class;

    /**
     * @param string $class
     */
    public function __construct($class)
    {
        $this->class = $class;
    }

    /**
     * @return mixed
     */
    public function create()
    {
        return new $this->class();
    }
}
