define(['jquery', 'bootstrap', 'jquery-ui'], function ($) {
  'use strict';
  var layout = {};

  layout.init = function (container) {
    container = $(container || document.body);

    container.find('[data-spy="scroll"]').each(function () {
      var $spy = $(this);
      $spy.scrollspy($spy.data());
      $spy = $(this).scrollspy('refresh');
      $('.scrollspy-nav ul.nav li').removeClass('active');
      $('.scrollspy-nav ul.nav li:first').addClass('active');
    });

    container.find('[data-toggle="tooltip"]').tooltip();

    var handlePopoverMouseout = function (e, popover) {
      var popoverHandler = $(e.relatedTarget).closest('.popover');
      if (!popoverHandler.length) {
        popover.data(
          'popover-timer',
          setTimeout(function () {
            popover.popover('hide');
            popover.data('popover-active', false);
          }, 500)
        );
      } else {
        popoverHandler.one('mouseout', function (evt) {
          handlePopoverMouseout(evt, popover);
        });
      }
    };
    $('form label [data-toggle="popover"]')
      .popover({
        animation: true,
        delay: {show: 0, hide: 0},
        html: true,
        trigger: 'manual',
      })
      .on('mouseover', function () {
        var popoverEl = $(this);
        clearTimeout(popoverEl.data('popover-timer'));
        if (!popoverEl.data('popover-active')) {
          popoverEl.data('popover-active', true);
          $(this).popover('show');
        }
      })
      .on('mouseout', function (e) {
        var popover = $(this);
        setTimeout(function () {
          handlePopoverMouseout(e, popover);
        }, 500);
      });

    setTimeout(function () {
      layout.scrollspyTop();
    }, 500);
  };

  layout.adjustScrollspy = function () {
    $('[data-spy="scroll"]').each(function () {
      var $spy = $(this);
      var spyHeight = $spy.innerHeight();

      var isMultipleRows = $spy.find('.responsive-section').length > 1;

      $spy.find('.responsive-section:last').each(function () {
        var $row = $(this);
        var titleHeight = $row.find('.scrollspy-title').outerHeight();
        var rowAdjHeight = isMultipleRows ? titleHeight + spyHeight : spyHeight;

        var rowOrigHeight = $row.data('originalHeight');
        if (!rowOrigHeight) {
          rowOrigHeight = $row.height();
          $row.data('originalHeight', rowOrigHeight);
        }

        if ($row.height() === rowAdjHeight) {
          return;
        }

        if (rowAdjHeight < rowOrigHeight) {
          rowAdjHeight = rowOrigHeight;
        }

        $row.outerHeight(rowAdjHeight);
      });

      $spy.scrollspy('refresh');
    });
  };

  layout.scrollspyTop = function () {
    $('[data-spy="scroll"]').each(function () {
      var $spy = $(this);
      var targetSelector = $spy.data('target');
      var target = $(targetSelector);

      target.each(function () {
        var $target = $(this);
        var firstItemHref = $target.find('li.active:first a').attr('href');
        var $firstItem = $(firstItemHref);
        var top = $firstItem.position().top;

        $spy.scrollTop(top);
      });
    });
  };

  return layout;
});
