'use strict';

define([
  'jquery',
  'underscore',
  'oro/translator',
  'pim/filter/filter',
  'pim/fetcher-registry',
  'pim/user-context',
  'pim/template/filter/product/identifier',
], function ($, _, __, BaseFilter, FetcherRegistry, UserContext, template) {
  return BaseFilter.extend({
    shortname: 'identifier',
    template: _.template(template),
    events: {
      'change [name="filter-value"]': 'updateState',
    },

    /**
     * {@inheritdoc}
     */
    isEmpty: function () {
      return _.isEmpty(this.getValue());
    },

    /**
     * {@inheritdoc}
     */
    renderInput: function () {
      return this.template({
        __: __,
        value: _.isArray(this.getValue()) ? this.getValue().join(', ') : '',
        field: this.getField(),
        isEditable: this.isEditable(),
      });
    },

    /**
     * {@inheritdoc}
     */
    getTemplateContext: function () {
      return BaseFilter.prototype.getTemplateContext.apply(this, arguments).then(
        function (templateContext) {
          return _.extend({}, templateContext, {
            removable: false,
          });
        }.bind(this)
      );
    },

    /**
     * {@inheritdoc}
     */
    updateState: function () {
      var value = this.$('[name="filter-value"]')
        .val()
        .split(/[\s,]+/);
      var cleanedValues = _.reject(value, function (val) {
        return '' === val;
      });

      this.setData({
        field: this.getField(),
        operator: 'IN',
        value: cleanedValues,
      });
    },
  });
});
