/**
 * Boolean attribute filter.
 *
 * @author    Yohan Blain <yohan.blain@akeneo.com>
 * @copyright 2016 Akeneo SAS (http://www.akeneo.com)
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 */
'use strict';

define([
  'jquery',
  'underscore',
  'oro/translator',
  'pim/filter/attribute/attribute',
  'pim/fetcher-registry',
  'pim/user-context',
  'pim/i18n',
  'pim/template/filter/attribute/boolean',
  'bootstrap.bootstrapswitch',
], function ($, _, __, BaseFilter, FetcherRegistry, UserContext, i18n, template) {
  return BaseFilter.extend({
    shortname: 'boolean',
    template: _.template(template),
    events: {
      'change [name="filter-value"]': 'updateState',
    },

    /**
     * {@inheritdoc}
     */
    configure: function () {
      this.listenTo(
        this.getRoot(),
        'pim_enrich:form:entity:pre_update',
        function (data) {
          _.defaults(data, {field: this.getCode(), operator: '=', value: true});
        }.bind(this)
      );

      return BaseFilter.prototype.configure.apply(this, arguments);
    },

    /**
     * {@inheritdoc}
     */
    renderInput: function (templateContext) {
      return this.template(
        _.extend({}, templateContext, {
          value: this.getValue(),
          field: this.getField(),
          labels: {
            on: __('pim_common.yes'),
            off: __('pim_common.no'),
          },
        })
      );
    },

    /**
     * {@inheritdoc}
     */
    postRender: function () {
      this.$('.switch').bootstrapSwitch();
    },

    /**
     * {@inheritdoc}
     */
    updateState: function () {
      this.setData({
        field: this.getField(),
        operator: '=',
        value: this.$('[name="filter-value"]').is(':checked'),
      });
    },
  });
});
