<?php

declare(strict_types=1);

namespace Akeneo\Platform\Bundle\CatalogVolumeMonitoringBundle\Persistence\Query\Sql;

use Akeneo\Platform\Component\CatalogVolumeMonitoring\Volume\Query\AverageMaxQuery;
use Akeneo\Platform\Component\CatalogVolumeMonitoring\Volume\ReadModel\AverageMaxVolumes;
use Doctrine\DBAL\Connection;

/**
 * @author    Elodie Rapos <elodie.raposo@akeneo.com>
 * @copyright 2018 Akeneo SAS (http://www.akeneo.com)
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class AverageMaxScopableAttributesPerFamily implements AverageMaxQuery
{
    private const VOLUME_NAME = 'average_max_scopable_attributes_per_family';

    /** @var Connection */
    private $connection;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * {@inheritdoc}
     */
    public function fetch(): AverageMaxVolumes
    {
        $sql = <<<SQL
            SELECT
                CEIL(AVG(count_only_scopable_attributes * 100 / count_attributes)) average,
                CEIL(MAX(count_only_scopable_attributes * 100 / count_attributes)) max
            FROM (
                SELECT fa.family_id as family_id, SUM(a.is_localizable = 0 AND a.is_scopable = 1) as count_only_scopable_attributes, COUNT(a.code) as count_attributes
                FROM pim_catalog_family_attribute as fa
                INNER JOIN pim_catalog_attribute as a ON fa.attribute_id = a.id
                GROUP BY fa.family_id
            ) as attr;
SQL;
        $result = $this->connection->executeQuery($sql)->fetchAssociative();
        $volume = new AverageMaxVolumes((int) $result['max'], (int) $result['average'], self::VOLUME_NAME);

        return $volume;
    }
}
