<?php

declare(strict_types=1);

namespace Akeneo\Platform\Bundle\CatalogVolumeMonitoringBundle\Persistence\Query\Sql;

use Akeneo\Platform\Component\CatalogVolumeMonitoring\Volume\Query\AverageMaxQuery;
use Akeneo\Platform\Component\CatalogVolumeMonitoring\Volume\ReadModel\AverageMaxVolumes;
use Doctrine\DBAL\Connection;

/**
 * @author    Elodie Raposo <elodie.raposo@akeneo.com>
 * @copyright 2018 Akeneo SAS (http://www.akeneo.com)
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class AverageMaxCategoriesInOneCategory implements AverageMaxQuery
{
    private const VOLUME_NAME = 'average_max_categories_in_one_category';

    /** @var Connection */
    private $connection;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * {@inheritdoc}
     */
    public function fetch(): AverageMaxVolumes
    {
        $sql = <<<SQL
          SELECT MAX(count_parent.count_parent_id) as max,
                CEIL(AVG(count_parent.count_parent_id)) as average
              FROM (
                 SELECT COUNT(c.parent_id) as count_parent_id
                  FROM pim_catalog_category c
                 WHERE c.parent_id is not null
                  GROUP BY c.parent_id
             ) as count_parent;
SQL;
        $result = $this->connection->executeQuery($sql)->fetchAssociative();

        $volume = new AverageMaxVolumes((int) $result['max'], (int) $result['average'], self::VOLUME_NAME);

        return $volume;
    }
}
