<?php

declare(strict_types=1);

namespace Akeneo\Platform\Bundle\CatalogVolumeMonitoringBundle\Persistence\Query\Sql;

use Akeneo\Platform\Component\CatalogVolumeMonitoring\Volume\Query\AverageMaxQuery;
use Akeneo\Platform\Component\CatalogVolumeMonitoring\Volume\ReadModel\AverageMaxVolumes;
use Doctrine\DBAL\Connection;

/**
 * @author    Alexandre Hocquard <alexandre.hocquard@akeneo.com>
 * @copyright 2018 Akeneo SAS (http://www.akeneo.com)
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class AverageMaxAttributesPerFamily implements AverageMaxQuery
{
    private const VOLUME_NAME = 'average_max_attributes_per_family';

    /** @var Connection */
    private $connection;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * {@inheritdoc}
     */
    public function fetch(): AverageMaxVolumes
    {
        $sql = <<<SQL
            SELECT 
                CEIL(AVG(a.count_attributes_per_family)) average,
                MAX(a.count_attributes_per_family) max
            FROM (
                SELECT count(attribute_id) count_attributes_per_family 
                FROM pim_catalog_family_attribute a
                GROUP BY family_id
            ) a
SQL;
        $result = $this->connection->executeQuery($sql)->fetchAssociative();
        $volume = new AverageMaxVolumes((int) $result['max'], (int) $result['average'], self::VOLUME_NAME);

        return $volume;
    }
}
