<?php

namespace Akeneo\Pim\Enrichment\Component\Product\Normalizer\Versioning\Product;

use Akeneo\Pim\Enrichment\Component\Product\Model\ProductPriceInterface;
use Symfony\Component\Serializer\Normalizer\CacheableSupportsMethodInterface;

/**
 * Normalize a product price
 *
 * @author    Gildas Quemener <gildas@akeneo.com>
 * @copyright 2014 Akeneo SAS (http://www.akeneo.com)
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class PriceNormalizer extends AbstractValueDataNormalizer implements CacheableSupportsMethodInterface
{
    const DECIMAL_PRECISION = 2;
    /** @var string[] */
    protected $supportedFormats = ['flat'];

    /**
     * {@inheritdoc}
     */
    public function supportsNormalization($data, $format = null): bool
    {
        return $data instanceof ProductPriceInterface && in_array($format, $this->supportedFormats);
    }

    public function hasCacheableSupportsMethod(): bool
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    protected function doNormalize($object, $format = null, array $context = [])
    {
        $data = $object->getData();
        if (null !== $data && '' !== $data) {
            $data = number_format($data, static::DECIMAL_PRECISION, '.', '');
        }

        return (string) $data;
    }

    /**
     * {@inheritdoc}
     */
    protected function getFieldName($object, array $context = [])
    {
        return sprintf('%s-%s', parent::getFieldName($object, $context), $object->getCurrency());
    }
}
