import {calculateAverageGrade} from '@akeneo-pim-community/data-quality-insights/src/application/component/Dashboard/ScoreDistributionSection/Chart/Tooltip';

describe('Tooltip calculates and displays the average grade', () => {
  test('A distribution as 50% of A and 50% of D should return an average grade B', () => {
    const data = {
      rank_5: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 23.53},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 100},
      },
      rank_4: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 23.53},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 50},
        4: {x: '2020-03-01', y: 11.76},
        5: {x: '2020-03-02', y: 11.76},
        6: {x: '2020-03-03', y: 0},
      },
      rank_3: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 5.88},
        5: {x: '2020-03-02', y: 5.88},
        6: {x: '2020-03-03', y: 0},
      },
      rank_2: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 0},
      },
      rank_1: {
        0: {x: '2020-02-26', y: 12.5},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 25},
        3: {x: '2020-02-29', y: 50},
        4: {x: '2020-03-01', y: 47.06},
        5: {x: '2020-03-02', y: 47.06},
        6: {x: '2020-03-03', y: 0},
      },
      rank_6: {
        0: {x: '2020-02-26', y: 0},
        1: {x: '2020-02-27', y: 0},
        2: {x: '2020-02-28', y: 0},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 0},
        5: {x: '2020-03-02', y: 0},
        6: {x: '2020-03-03', y: 0},
      },
    };

    const datum = {
      xName: '2020-02-29',
      _x: 7,
      _y: 100,
      _stack: 1,
      _group: 3,
      x: '2020-02-29',
      y: 100,
      _y0: 0,
      _y1: 100,
      _x1: 7,
    };

    const averageGrade = calculateAverageGrade(data, datum);
    expect(averageGrade).toBe('B');
  });

  test('A distribution as 100% of E should return an average grade E', () => {
    const data = {
      rank_5: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 23.53},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 100},
      },
      rank_4: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 23.53},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 11.76},
        5: {x: '2020-03-02', y: 11.76},
        6: {x: '2020-03-03', y: 0},
      },
      rank_3: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 5.88},
        5: {x: '2020-03-02', y: 5.88},
        6: {x: '2020-03-03', y: 0},
      },
      rank_2: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 0},
      },
      rank_1: {
        0: {x: '2020-02-26', y: 12.5},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 25},
        3: {x: '2020-02-29', y: 41.18},
        4: {x: '2020-03-01', y: 47.06},
        5: {x: '2020-03-02', y: 47.06},
        6: {x: '2020-03-03', y: 0},
      },
      rank_6: {
        0: {x: '2020-02-26', y: 0},
        1: {x: '2020-02-27', y: 0},
        2: {x: '2020-02-28', y: 0},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 0},
        5: {x: '2020-03-02', y: 0},
        6: {x: '2020-03-03', y: 0},
      },
    };

    const datum = {
      xName: '2020-03-03',
      _x: 7,
      _y: 100,
      _stack: 1,
      _group: 6,
      x: '2020-03-03',
      y: 100,
      _y0: 0,
      _y1: 100,
      _x1: 7,
    };

    const averageGrade = calculateAverageGrade(data, datum);
    expect(averageGrade).toBe('E');
  });

  test('A distribution as 50% of A, 25% of C and 25% of D should return an average grade B', () => {
    const data = {
      rank_5: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 23.53},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 0},
      },
      rank_4: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 23.53},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 11.76},
        5: {x: '2020-03-02', y: 11.76},
        6: {x: '2020-03-03', y: 25},
      },
      rank_3: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 5.88},
        5: {x: '2020-03-02', y: 5.88},
        6: {x: '2020-03-03', y: 25},
      },
      rank_2: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 0},
      },
      rank_1: {
        0: {x: '2020-02-26', y: 12.5},
        1: {x: '2020-02-27', y: 17.65},
        2: {x: '2020-02-28', y: 25},
        3: {x: '2020-02-29', y: 41.18},
        4: {x: '2020-03-01', y: 47.06},
        5: {x: '2020-03-02', y: 47.06},
        6: {x: '2020-03-03', y: 50},
      },
      rank_6: {
        0: {x: '2020-02-26', y: 0},
        1: {x: '2020-02-27', y: 0},
        2: {x: '2020-02-28', y: 0},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 0},
        5: {x: '2020-03-02', y: 0},
        6: {x: '2020-03-03', y: 0},
      },
    };

    const datum = {
      xName: '2020-03-03',
      _x: 7,
      _y: 100,
      _stack: 1,
      _group: 6,
      x: '2020-03-03',
      y: 100,
      _y0: 0,
      _y1: 100,
      _x1: 7,
    };

    const averageGrade = calculateAverageGrade(data, datum);
    expect(averageGrade).toBe('B');
  });

  test('A distribution as 20% of A, 20% of B, 20% of C, 20% of D and 20% of E should return an average grade C', () => {
    const data = {
      rank_5: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 50},
      },
      rank_4: {
        0: {x: '2020-02-26', y: 25},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 11.76},
        5: {x: '2020-03-02', y: 11.76},
        6: {x: '2020-03-03', y: 0},
      },
      rank_3: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 5.88},
        5: {x: '2020-03-02', y: 5.88},
        6: {x: '2020-03-03', y: 25},
      },
      rank_2: {
        0: {x: '2020-02-26', y: 18.75},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 25},
      },
      rank_1: {
        0: {x: '2020-02-26', y: 12.5},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 25},
        3: {x: '2020-02-29', y: 41.18},
        4: {x: '2020-03-01', y: 47.06},
        5: {x: '2020-03-02', y: 47.06},
        6: {x: '2020-03-03', y: 0},
      },
      rank_6: {
        0: {x: '2020-02-26', y: 0},
        1: {x: '2020-02-27', y: 0},
        2: {x: '2020-02-28', y: 0},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 0},
        5: {x: '2020-03-02', y: 0},
        6: {x: '2020-03-03', y: 0},
      },
    };

    const datum = {
      xName: '2020-02-27',
      _x: 7,
      _y: 100,
      _stack: 1,
      _group: 1,
      x: '2020-02-27',
      y: 100,
      _y0: 0,
      _y1: 100,
      _x1: 7,
    };

    const averageGrade = calculateAverageGrade(data, datum);
    expect(averageGrade).toBe('C');
  });

  test('A distribution as 38% of A, 16% of B, 17% of C, 9% of D and 20% of E should return an average grade C', () => {
    const data = {
      rank_5: {
        0: {x: '2020-02-26', y: 20},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 50},
      },
      rank_4: {
        0: {x: '2020-02-26', y: 9},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 11.76},
        5: {x: '2020-03-02', y: 11.76},
        6: {x: '2020-03-03', y: 0},
      },
      rank_3: {
        0: {x: '2020-02-26', y: 17},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 11.76},
        4: {x: '2020-03-01', y: 5.88},
        5: {x: '2020-03-02', y: 5.88},
        6: {x: '2020-03-03', y: 25},
      },
      rank_2: {
        0: {x: '2020-02-26', y: 16},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 18.75},
        3: {x: '2020-02-29', y: 17.65},
        4: {x: '2020-03-01', y: 17.65},
        5: {x: '2020-03-02', y: 17.65},
        6: {x: '2020-03-03', y: 25},
      },
      rank_1: {
        0: {x: '2020-02-26', y: 38},
        1: {x: '2020-02-27', y: 20},
        2: {x: '2020-02-28', y: 25},
        3: {x: '2020-02-29', y: 41.18},
        4: {x: '2020-03-01', y: 47.06},
        5: {x: '2020-03-02', y: 47.06},
        6: {x: '2020-03-03', y: 0},
      },
      rank_6: {
        0: {x: '2020-02-26', y: 0},
        1: {x: '2020-02-27', y: 0},
        2: {x: '2020-02-28', y: 0},
        3: {x: '2020-02-29', y: 0},
        4: {x: '2020-03-01', y: 0},
        5: {x: '2020-03-02', y: 0},
        6: {x: '2020-03-03', y: 0},
      },
    };

    const datum = {
      xName: '2020-02-26',
      _x: 7,
      _y: 100,
      _stack: 1,
      _group: 0,
      x: '2020-02-26',
      y: 100,
      _y0: 0,
      _y1: 100,
      _x1: 7,
    };

    const averageGrade = calculateAverageGrade(data, datum);
    expect(averageGrade).toBe('C');
  });
});
