import React from 'react';
import {IllustrationProps} from './IllustrationProps';
import Export from '../../static/illustrations/Export.svg';

const ExportIllustration = ({title, size = 256, ...props}: IllustrationProps) => (
  <svg width={size} height={size} viewBox="0 0 256 256" {...props}>
    {title && <title>{title}</title>}
    <image href={Export} />
  </svg>
);

export {ExportIllustration};
