import React from 'react';
import {IllustrationProps} from './IllustrationProps';
import DeleteFamilyVariant from '../../static/illustrations/DeleteFamilyVariant.svg';
import {BrandedPath} from '../theme';

const DeleteFamilyVariantIllustration = ({title, size = 256, ...props}: IllustrationProps) => (
  <svg width={size} height={size} viewBox="0 0 256 256" {...props}>
    {title && <title>{title}</title>}
    <image href={DeleteFamilyVariant} />
    <BrandedPath d="M124.9121,86.3261 C124.9421,86.4461 124.9721,86.5291 124.9791,86.5551 C124.9821,86.5591 124.9761,86.5551 124.9791,86.5551 C124.9791,86.5561 124.9781,86.5551 124.9781,86.5551 C124.9131,83.9751 126.4471,83.0211 127.0461,81.3561 C127.0501,81.3321 127.0571,81.3051 127.0671,81.2741 C127.0801,81.2371 127.0911,81.1981 127.1001,81.1591 C127.2051,80.6941 127.0551,80.1321 126.7341,79.5331 C126.7321,79.5291 126.7301,79.5261 126.7291,79.5231 C126.7031,79.4731 126.6751,79.4241 126.6451,79.3741 C126.6451,79.3741 126.6441,79.3731 126.6441,79.3721 C126.5921,79.2801 126.5341,79.1881 126.4741,79.0961 C126.4681,79.0861 126.4621,79.0761 126.4551,79.0661 C126.4381,79.0411 126.4211,79.0151 126.4041,78.9901 C126.3871,78.9641 126.3691,78.9371 126.3511,78.9121 C126.3331,78.8871 126.3151,78.8611 126.2971,78.8361 L126.2411,78.7571 C126.2271,78.7391 126.2141,78.7211 126.1991,78.7021 C125.6781,77.9971 124.9811,77.2861 124.2461,76.6571 C124.2461,76.6571 124.2411,76.6481 124.2461,76.6571 C124.2741,77.6291 124.2131,78.5941 124.0611,79.3561 C123.8801,80.2761 123.4631,81.3321 122.9261,82.2761 C121.8531,82.1041 120.7691,81.7681 119.9371,81.3351 C119.2421,80.9721 118.4561,80.4231 117.7131,79.7871 C117.7151,79.8671 117.7191,79.9471 117.7221,80.0281 C117.7231,80.0521 117.7251,80.0761 117.7251,80.0991 C117.7281,80.1571 117.7311,80.2151 117.7351,80.2721 C117.7361,80.2991 117.7381,80.3251 117.7401,80.3511 C117.7441,80.4101 117.7491,80.4671 117.7541,80.5241 C117.7561,80.5481 117.7581,80.5711 117.7591,80.5951 C117.7661,80.6681 117.7721,80.7391 117.7791,80.8121 C117.7801,80.8191 117.7801,80.8261 117.7811,80.8331 C117.7901,80.9171 117.7991,81.0011 117.8091,81.0841 C117.8091,81.0911 117.8101,81.0971 117.8111,81.1031 C117.8211,81.1781 117.8301,81.2521 117.8411,81.3261 C117.8431,81.3411 117.8451,81.3551 117.8471,81.3711 C117.8561,81.4381 117.8661,81.5061 117.8771,81.5731 C117.8801,81.5861 117.8821,81.5981 117.8841,81.6121 C117.8961,81.6901 117.9091,81.7671 117.9231,81.8441 C117.9241,81.8441 117.9241,81.8451 117.9241,81.8451 C117.9691,82.0901 118.0201,82.3271 118.0791,82.5551 C118.0801,82.5581 118.0811,82.5611 118.0811,82.5641 C118.1811,82.9461 118.3001,83.3001 118.4391,83.6121 C118.4601,83.6571 118.4801,83.7021 118.5021,83.7461 C118.5031,83.7471 118.5031,83.7491 118.5041,83.7511 L118.5051,83.7511 C118.5231,83.7911 118.5441,83.8301 118.5631,83.8681 L118.5641,83.8681 C118.5641,83.8681 118.5651,83.8711 118.5661,83.8731 C118.5881,83.9141 118.6091,83.9541 118.6331,83.9921 C118.6361,83.9981 118.6391,84.0031 118.6411,84.0081 C118.6411,84.0081 118.6411,84.0091 118.6421,84.0091 C118.6721,84.0591 118.7021,84.1071 118.7311,84.1541 C118.7371,84.1621 118.7421,84.1701 118.7471,84.1771 C118.7491,84.1801 118.7511,84.1811 118.7531,84.1851 C118.7881,84.2371 118.8241,84.2881 118.8621,84.3361 C118.8881,84.3691 118.9141,84.4011 118.9411,84.4321 C118.9531,84.4461 118.9651,84.4581 118.9761,84.4711 C118.9931,84.4891 119.0111,84.5071 119.0271,84.5251 C119.0401,84.5381 119.0541,84.5501 119.0671,84.5631 C119.0831,84.5791 119.1001,84.5951 119.1171,84.6101 C119.1311,84.6221 119.1441,84.6331 119.1581,84.6441 C119.1761,84.6591 119.1931,84.6731 119.2111,84.6861 C119.2251,84.6961 119.2381,84.7071 119.2521,84.7171 C119.2711,84.7301 119.2911,84.7421 119.3091,84.7551 C119.3221,84.7641 119.3361,84.7721 119.3491,84.7801 C119.3711,84.7931 119.3921,84.8041 119.4151,84.8151 C119.4261,84.8201 119.4371,84.8281 119.4491,84.8331 C119.4821,84.8491 119.5171,84.8641 119.5521,84.8771 C119.5751,84.8861 119.5961,84.8941 119.6141,84.9041 C121.2881,85.4881 123.0081,84.9011 124.9791,86.5551" />
  </svg>
);

export {DeleteFamilyVariantIllustration};
