import React from 'react';
import {IllustrationProps} from './IllustrationProps';
import ClientError from '../../static/illustrations/ClientError.svg';
import {BrandedPath} from '../theme';

const ClientErrorIllustration = ({title, size = 500, ...props}: IllustrationProps) => (
  <svg width={size} height={size} viewBox="0 0 500 250" {...props}>
    {title && <title>{title}</title>}
    <image href={ClientError} />
    <g transform="translate(1.000000, 8.000000)">
      <BrandedPath d="M252.39,136 C252.45,136.18 252.5,136.3 252.52,136.34 L252.52,136.34 C252.12,132.45 254.33,130.82 255.04,128.24 C255.036758,128.196727 255.036758,128.153273 255.04,128.11 C255.043053,128.050039 255.043053,127.989961 255.04,127.93 C255.085434,127.061431 254.823434,126.204618 254.3,125.51 L254.3,125.51 L254.16,125.29 L254.16,125.29 L253.87,124.89 L253.87,124.89 L253.78,124.78 L253.69,124.67 L253.6,124.56 L253.51,124.45 L253.44,124.37 C252.484426,123.302908 251.414697,122.34384 250.25,121.51 L250.25,121.51 C250.396646,122.872733 250.396646,124.247267 250.25,125.61 C250.030222,127.188136 249.568112,128.722879 248.88,130.16 C247.290794,130.043756 245.729064,129.682838 244.25,129.09 C242.994353,128.528205 241.803938,127.830722 240.7,127.01 L240.7,127.37 L240.7,127.48 C240.7,127.57 240.7,127.65 240.7,127.74 L240.7,127.86 L240.7,128.12 L240.7,128.23 L240.76,128.56 L240.76,128.56 L240.83,128.94 L240.83,128.94 L240.9,129.27 L240.9,129.34 L240.97,129.64 L240.97,129.7 L241.06,130.04 L241.06,130.04 C241.16,130.406667 241.266667,130.76 241.38,131.1 L241.38,131.1 C241.557606,131.630484 241.778343,132.145538 242.04,132.64 L242.15,132.83 L242.15,132.83 L242.25,133 L242.25,133 L242.36,133.17 L242.36,133.17 L242.36,133.17 L242.36,133.17 L242.51,133.38 L242.51,133.38 L242.51,133.38 L242.69,133.59 L242.82,133.73 L242.88,133.78 L242.96,133.86 L243.02,133.91 L243.1,133.97 L243.17,133.97 L243.25,134.03 L243.32,134.03 L243.41,134.08 L243.47,134.08 L243.58,134.08 L243.63,134.08 L243.79,134.13 L243.89,134.13 C246.49,134.82 249.02,133.73 252.2,136" />
    </g>
  </svg>
);

export {ClientErrorIllustration};
