import React from 'react';
import {IllustrationProps} from './IllustrationProps';
import App from '../../static/illustrations/App.svg';
import {BrandedPath} from '../theme';

const AppIllustration = ({title, size = 256, ...props}: IllustrationProps) => (
  <svg width={size} height={size} viewBox="0 0 256 256" {...props}>
    {title && <title>{title}</title>}
    <image href={App} />
    <BrandedPath d="M142.5342,139.3426 C142.6112,139.5716 142.6802,139.7286 142.6992,139.7796 C142.7062,139.7856 142.6932,139.7776 142.6992,139.7796 C142.6992,139.7796 142.6992,139.7816 142.6992,139.7796 C142.7002,139.7806 142.6982,139.7796 142.6982,139.7796 C142.1802,134.7666 145.0222,132.6776 145.9362,129.3476 C145.9412,129.2976 145.9502,129.2436 145.9662,129.1836 C145.9842,129.1096 146.0002,129.0316 146.0112,128.9546 C146.1472,128.0336 145.7692,126.9616 145.0552,125.8446 C145.0522,125.8376 145.0472,125.8316 145.0432,125.8266 C144.9842,125.7336 144.9222,125.6406 144.8582,125.5476 C144.8582,125.5476 144.8562,125.5456 144.8552,125.5436 C144.7382,125.3746 144.6122,125.2026 144.4812,125.0306 C144.4682,125.0146 144.4562,124.9946 144.4412,124.9786 C144.4042,124.9316 144.3662,124.8846 144.3302,124.8376 C144.2922,124.7886 144.2542,124.7406 144.2162,124.6946 C144.1762,124.6466 144.1382,124.5996 144.0982,124.5536 C144.0582,124.5046 144.0172,124.4566 143.9762,124.4076 C143.9492,124.3756 143.9182,124.3416 143.8882,124.3076 C142.7652,123.0136 141.3032,121.7346 139.7772,120.6216 C139.7772,120.6216 139.7652,120.6056 139.7772,120.6216 C139.9782,122.5086 140.0042,124.3966 139.8262,125.9046 C139.6102,127.7236 138.9592,129.8406 138.0552,131.7596 C135.9422,131.5866 133.7822,131.0976 132.0962,130.3776 C130.6882,129.7766 129.0742,128.8266 127.5312,127.7006 C127.5482,127.8586 127.5672,128.0126 127.5852,128.1696 C127.5912,128.2156 127.5972,128.2616 127.6032,128.3086 C127.6182,128.4206 127.6322,128.5306 127.6492,128.6436 C127.6552,128.6946 127.6632,128.7456 127.6712,128.7966 C127.6872,128.9086 127.7042,129.0206 127.7222,129.1306 C127.7292,129.1756 127.7372,129.2216 127.7442,129.2666 C127.7672,129.4066 127.7912,129.5466 127.8172,129.6866 C127.8182,129.7006 127.8202,129.7146 127.8242,129.7286 C127.8522,129.8906 127.8842,130.0516 127.9162,130.2116 C127.9172,130.2246 127.9212,130.2356 127.9242,130.2486 C127.9522,130.3936 127.9812,130.5346 128.0132,130.6776 C128.0192,130.7066 128.0252,130.7356 128.0312,130.7646 C128.0602,130.8946 128.0912,131.0246 128.1212,131.1536 C128.1292,131.1786 128.1352,131.2026 128.1402,131.2296 C128.1772,131.3776 128.2132,131.5276 128.2522,131.6726 C128.2532,131.6736 128.2532,131.6756 128.2532,131.6756 C128.3782,132.1456 128.5142,132.6006 128.6632,133.0356 C128.6652,133.0416 128.6672,133.0466 128.6682,133.0516 C128.9192,133.7806 129.2052,134.4506 129.5232,135.0376 C129.5702,135.1226 129.6182,135.2066 129.6662,135.2886 C129.6692,135.2916 129.6692,135.2946 129.6712,135.2976 L129.6722,135.2986 C129.7162,135.3726 129.7602,135.4466 129.8042,135.5166 L129.8052,135.5176 C129.8052,135.5176 129.8092,135.5236 129.8102,135.5256 C129.8582,135.6026 129.9072,135.6776 129.9582,135.7486 C129.9652,135.7586 129.9712,135.7676 129.9782,135.7776 L129.9792,135.7796 C130.0432,135.8736 130.1102,135.9626 130.1752,136.0486 C130.1872,136.0636 130.1982,136.0766 130.2092,136.0906 C130.2122,136.0956 130.2172,136.0996 130.2212,136.1066 C130.2972,136.2026 130.3752,136.2956 130.4562,136.3826 C130.5112,136.4446 130.5682,136.5016 130.6252,136.5596 C130.6492,136.5826 130.6752,136.6056 130.6992,136.6276 C130.7342,136.6616 130.7702,136.6946 130.8062,136.7266 C130.8342,136.7496 130.8612,136.7706 130.8892,136.7936 C130.9242,136.8226 130.9602,136.8506 130.9952,136.8776 C131.0222,136.8986 131.0502,136.9176 131.0792,136.9386 C131.1162,136.9636 131.1512,136.9886 131.1882,137.0136 C131.2162,137.0296 131.2452,137.0476 131.2732,137.0656 C131.3122,137.0876 131.3512,137.1096 131.3892,137.1316 C131.4172,137.1466 131.4442,137.1596 131.4712,137.1736 C131.5152,137.1946 131.5592,137.2136 131.6062,137.2336 C131.6272,137.2406 131.6502,137.2536 131.6742,137.2616 C131.7422,137.2896 131.8112,137.3126 131.8812,137.3316 C131.9282,137.3456 131.9682,137.3606 132.0062,137.3746 C135.3532,138.2596 138.6122,136.8586 142.6992,139.7796" />
  </svg>
);

export {AppIllustration};
