import React from 'react';
import {IllustrationProps} from './IllustrationProps';
import AkeneoCloudEdition from '../../static/illustrations/AkeneoCloudEdition.svg';
import {BrandedPath} from '../theme';

const AkeneoCloudEditionIllustration = ({title, size = 256, ...props}: IllustrationProps) => (
  <svg width={size} height={size} viewBox="0 0 256 256" {...props}>
    {title && <title>{title}</title>}
    <image href={AkeneoCloudEdition} />
    <g fill="none" fillRule="evenodd">
      <BrandedPath d="M142.533 113.72c.078.23.146.386.166.438.007.005-.006-.002 0 0 0 0 0 .001 0 0 .001 0 0 0 0 0-.52-5.014 2.323-7.103 3.236-10.433.005-.05.015-.103.03-.163.02-.075.035-.153.046-.23.135-.921-.242-1.993-.957-3.11-.003-.006-.008-.012-.01-.018a10.36 10.36 0 00-.187-.278s-.002-.002-.002-.005a14.074 14.074 0 00-.374-.513l-.04-.052c-.037-.046-.076-.093-.11-.14l-.115-.144-.118-.14c-.04-.05-.08-.097-.122-.147l-.089-.1c-1.123-1.294-2.584-2.573-4.11-3.686 0 0-.013-.015 0 0 .201 1.888.227 3.775.048 5.284-.216 1.819-.866 3.936-1.77 5.855-2.113-.174-4.274-.663-5.959-1.383-1.409-.6-3.022-1.55-4.565-2.676.017.157.035.312.054.468l.018.14.045.334.023.153c.016.112.033.223.051.334l.022.136.072.42.007.042a19.656 19.656 0 00.1.52c.03.144.058.285.09.43l.018.087.09.388a.53.53 0 01.018.076c.038.148.074.297.113.444a20.364 20.364 0 00.411 1.363l.005.016c.251.728.536 1.398.855 1.985.047.085.095.17.143.25.002.003.002.007.005.01h.001c.043.076.088.15.132.22l.006.008c.048.076.097.151.147.222v.001l.021.03v.001c.065.094.131.184.197.27l.034.04c.003.007.008.01.011.017a5.367 5.367 0 00.405.453l.073.069.108.099.083.066c.035.03.071.056.105.084.028.022.056.04.085.06a2.635 2.635 0 00.194.129l.116.064c.028.017.055.03.081.043.045.022.09.04.135.06.022.007.045.02.068.028.07.028.138.052.208.07.047.014.087.03.125.043 3.346.885 6.606-.516 10.693 2.406" />
    </g>
  </svg>
);

export {AkeneoCloudEditionIllustration};
