import React from 'react';
import {IconProps} from './IconProps';

const InfoIcon = ({title, size = 24, color = 'currentColor', ...props}: IconProps) => (
  <svg viewBox="0 0 24 24" width={size} height={size} {...props}>
    {title && <title>{title}</title>}
    <path
      d="M14.651 9l-2.835 9.228c-.156.528-.235.874-.235 1.038a.37.37 0 00.125.266c.083.082.17.124.263.124.156 0 .313-.065.47-.195.415-.32.912-.9 1.493-1.74l.47.26c-1.392 2.276-2.871 3.414-4.438 3.414-.6 0-1.077-.158-1.432-.474A1.537 1.537 0 018 19.72c0-.32.078-.727.235-1.22l1.922-6.204c.185-.597.277-1.047.277-1.35 0-.19-.088-.36-.263-.506-.175-.147-.415-.221-.72-.221-.137 0-.303.004-.497.013l.18-.52L13.82 9h.83zm-.632-6c.571 0 1.053.186 1.445.558.392.372.588.822.588 1.35 0 .528-.199.978-.595 1.35a2.026 2.026 0 01-1.438.558 2.008 2.008 0 01-1.424-.558A1.784 1.784 0 0112 4.908c0-.528.196-.978.588-1.35A2.001 2.001 0 0114.018 3z"
      fill={color}
      fillRule="evenodd"
    />
  </svg>
);

export {InfoIcon};
