import React from 'react';
import {IconProps} from './IconProps';

const AttributeTextareaIcon = ({title, size = 24, color = 'currentColor', ...props}: IconProps) => (
  <svg viewBox="0 0 24 24" width={size} height={size} {...props}>
    {title && <title>{title}</title>}
    <g fill="none" fillRule="evenodd">
      <path d="M2.5 18.5v3m0 0h3m16-19v3m-3-3h3" stroke={color} strokeLinecap="round" strokeLinejoin="round" />
      <path
        d="M11.5 21a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1zm-6 0a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1zm6 0a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1zm0-2a.5.5 0 110 1 .5.5 0 010-1zM16.907 6L17 9.082h-.415c-.204-.968-.462-1.599-.776-1.89-.313-.293-.973-.44-1.978-.44h-.967v9.282c0 .703.105 1.138.314 1.306.209.168.667.28 1.373.332V18H9.49v-.328c.735-.059 1.193-.186 1.373-.38.181-.195.272-.685.272-1.47v-9.07h-.967c-.96 0-1.614.145-1.961.435-.348.289-.61.92-.784 1.895H7L7.102 6h9.805zM21.5 17a.5.5 0 110 1 .5.5 0 010-1zm-19-1a.5.5 0 110 1 .5.5 0 010-1zm19-1a.5.5 0 110 1 .5.5 0 010-1zm-19-1a.5.5 0 110 1 .5.5 0 010-1zm19-1a.5.5 0 110 1 .5.5 0 010-1zm-19-1a.5.5 0 110 1 .5.5 0 010-1zm19-1a.5.5 0 110 1 .5.5 0 010-1zm-19-1a.5.5 0 110 1 .5.5 0 010-1zm19-1a.5.5 0 110 1 .5.5 0 010-1zm-19-1a.5.5 0 110 1 .5.5 0 010-1zm19-1a.5.5 0 110 1 .5.5 0 010-1zm-19-1a.5.5 0 110 1 .5.5 0 010-1zm0-2a.5.5 0 110 1 .5.5 0 010-1zm0-2a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1zm4 0a.5.5 0 110 1 .5.5 0 010-1zm6 0a.5.5 0 110 1 .5.5 0 010-1zm-8 0a.5.5 0 110 1 .5.5 0 010-1zm4 0a.5.5 0 110 1 .5.5 0 010-1zm2 0a.5.5 0 110 1 .5.5 0 010-1z"
        fill={color}
      />
    </g>
  </svg>
);

export {AttributeTextareaIcon};
