# 6.0.x

# 6.0.112 (2023-12-22)

- PIM-11249: Keep resolution metadata (DPI) of transformed asset images

# 6.0.110 (2023-11-24)

- PIM-10985: Mark skipped migrations as executed

# 6.0.109 (2023-11-08)

# 6.0.108 (2023-11-06)

## Bug fixes

- PIM-11256: Filter values not bound to channel on datagrid

# 6.0.107 (2023-10-19)

# 6.0.106 (2023-10-11)


## Bug fixes

- PIM-11227: Fix impossible to change channel from one channel with multiple locales to one channel with only one locale

# 6.0.105 (2023-09-25)

- PIM-11192: Fix boolean switch for Japan locale

# 6.0.104 (2023-09-22)

# 6.0.103 (2023-09-22)

# 6.0.102 (2023-09-13)

## Bug fixes

- PIM-10918: Fix migrations not executed but added in executed migrations
# 6.0.101 (2023-09-13)

# 6.0.100 (2023-09-07)

# 6.0.99 (2023-08-30)

- PIM-11155: Fix scroll on datagrid columns manager when browser zoom is not 100%

# 6.0.98 (2023-08-17)

- PIM-11133: Add a loader on confirmation step when connecting an App to prevent button spamming

# 6.0.97 (2023-08-11)

# 6.0.96 (2023-08-03)

- [Backport PIM-10868] PIM-11123: Fix checkboxes on category trees

# 6.0.95 (2023-07-31)

- [Backport PIM-10844] PIM-11106 : Filter empty attribute option labels

# 6.0.94 (2023-07-31)

# 6.0.93 (2023-07-24)

# 6.0.92 (2023-07-19)

# 6.0.91 (2023-07-13)

## Bug fixes

- [Backport CPM-653] PIM-11083: Do not sort on _id in ES cursors

# 6.0.90 (2023-07-06)

- PIM-11070: Increase the oro_access_role label column to VARCHAR(255)

# 6.0.89 (2023-06-29)

## Improvements

- Add interfaces

# 6.0.88 (2023-06-28)

# 6.0.87 (2023-06-14)

# 6.0.86 (2023-05-29)

# 6.0.85 (2023-05-23)

## Bug fixes

- PIM-10997: Update error message when trying to delete role with linked users or connections

# 6.0.84 (2023-05-16)

# 6.0.83 (2023-05-15)

## Bug fixes

- PIM-10928: Fix pim:update:check-requirements can create indexes which are unreachable from the PIM
- [Backport PIM-10820] PIM-10981: Export product attribute options with the right case

# 6.0.82 (2023-04-24)

## Bug fixes

- [Backport PIM-10877] PIM-10954: Fix sequential edit when grid is sorted by quality score

# 6.0.81 (2023-04-18)

## Bug fixes

- [Backport PIM-10887] PIM-10937: Prevent channel creation on validation error during import

# 6.0.80 (2023-04-11)

## Bug fixes

- PIM-10922: Update dompdf library

# 6.0.79 (2023-04-04)

# 6.0.78 (2023-03-29)

## Bug fixes

- PIM-10913: Fix attribute creation form when a label contains a question mark

# 6.0.77 (2023-03-24)

# 6.0.76 (2023-03-08)

## Bug fixes

- PIM-10878: Fix filtering products with identifiers would not display some product models

# 6.0.75 (2023-03-02)

# 6.0.74 (2023-03-02)

## Bug fixes

- PIM-10780: Fix PEF display for localizable values with locale codes with wrong case

# 6.0.73 (2023-02-28)

## Bug fixes

- [Backport PIM-10606] PIM-10865: Fix computeFamilyVariantStructureChange on attribute removal

# 6.0.72 (2023-02-27)

# 6.0.71 (2023-02-21)

## Improvements

- PIM-1353: Add script to check that PIM is ready to be upgraded to v7

# 6.0.70 (2023-02-16)

## Bug fixes

- PIM-10826: Fix GET system-information endpoint with wrong answers

# 6.0.69 (2023-02-13)

## Bug fixes:

- PIM-10834: Fix regression on parent filter in LIST products endpoint

# 6.0.68 (2023-02-09)

## Bug fixes

- PIM-10810: Optimize completeness saving

# 6.0.67 (2023-02-06)

# 6.0.66 (2023-02-02)

## Bug fixes

- [Backport PIM-10802] PIM-10818: Fix wysiwyg-field add link event
- PIM-10786: Fix misleading message when session expires

# 6.0.65 (2023-01-26)

## Bug fixes

- PIM-10794: Fix error message on search attributes for product and product models GET

# 6.0.64 (2023-01-23)

# 6.0.63 (2023-01-12)

## Bug fixes

- [Backport PIM-10516] PIM-10787: Do not run the remove completeness job when there is no need

# 6.0.62 (2022-12-23)

## Bug fixes

- PIM-10687: Fix high memory consumption when computing completeness for prices with inactive currencies

# 6.0.61 (2022-12-15)

# 6.0.60 (2022-12-14)

# 6.0.59 (2022-12-14)

# 6.0.58 (2022-12-13)

## Bug fixes

- [Backport PIM-10246] PIM-10765: Fix oom in Process Tracker
- [Backport PIM-10672] PIM-10690: Command to create/add roles with all existing permission

# 6.0.57 (2022-12-07)

# 6.0.56 (2022-11-28)

## Bug fixes

- PIM-10734: Assets export fails because of a failed warning messages

# 6.0.55 (2022-11-21)

# 6.0.54 (2022-11-18)

## Bug fixes

- PIM-10688: Fix error on toLocaleLowerCase for select attribute options

# 6.0.53 (2022-11-10)

# 6.0.52 (2022-11-08)

## Bug fixes

- PIM-10664 Fix expand/collapse arrow disappearing after category creation
- PIM-10699: Fix "All" is exported allong with the user groups on the user export

# 6.0.51 (2022-11-03)

# 6.0.50 (2022-11-02)

# 6.0.49 (2022-10-31)

# 6.0.48 (2022-10-28)

# 6.0.47 (2022-10-27)

## Bug fixes

- PIM-10677: [Backport PIM-10420 and PIM-10484] Fix job still shows under in progress when failed
- PIM-10683: Fix performance regression in CSV and XLSX product and product model export

# 6.0.46 (2022-10-20)

## Bug fixes

- PIM-10670: Fix memory leak on creating combinations for currencies
- PIM-10679: Fix out of sort memory on ProductModelImagesFromCodes

# 6.0.45 (2022-10-06)

## Bug fixes

- PIM-10652: [Backport PIM-10646] Fix export with label from a select attribute containing uppercase in its code exports code and not labels

# 6.0.44 (2022-09-23)

## Bug fixes

- PIM-10631: increase the FOS OAuth scope column to VARCHAR(1000)
- PIM-10435: [Backport] Fix search_after requests with codes using uppercase accented characters

# 6.0.43 (2022-09-20)

## Improvements

- CPM-721: Add line break support for attribute guidelines

# 6.0.42 (2022-09-02)

# 6.0.41 (2022-08-29)

- MW-370: Shift marketplace API service to new one

# 6.0.40 (2022-08-25)

## Bug fixes

- PIM-10590: Fix capitalizing every first letter of attribute label in Data Quality Insights tab

# 6.0.39 (2022-08-23)

- OCT-107: Lock lcobucci/jwt version to ~4.1.5

# 6.0.38 (2022-08-17)

# 6.0.37 (2022-07-27)

## Bug fixes

- OCT-76: Fixed redundant authentication prompt during App activation

# 6.0.36 (2022-07-21)

## Bug fixes

- PIM-10494: Fix memory issue when trying to delete a job profile with many warnings

# 6.0.35 (2022-07-12)

# 6.0.34 (2022-07-05)

## Bug fixes

- OCT-77: Fix translation error in the PIM App Store

# 6.0.33 (2022-07-01)

# 6.0.32 (2022-06-28)

## Improvement

- Improvement: Update Composer dependencies and fix ArabicHtmlFormatterSpec
- Improvement: Update PhpStan to 1.7.14

# 6.0.31 (2022-06-14)

# 6.0.30 (2022-06-08)

## Bug fixes

- PIM-10470: Refresh process tracker job detail page when job execution id param changes

# 6.0.29 (2022-05-25)

## Bug fixes

- PIM-10457: Fixed inconsistency with column oro_user.consecutive_authentication_failure_counter when migrating from v6 to serenity
- PIM-10449: Remove old table related to old queue system
- PIM-10451: Add migration to add an index on start_time on the job_execution table
- MW-373: Prepare the marketplace migration to another subdomain
- PIM-10452, PIM-10454, PIM-10455, PIM-10456 : Fix migration to set some fields to NOT NULL on job & step execution tables
- PIM-10453: Add migration to add an index on updated on pim_catalog_category table

# 6.0.28 (2022-05-13)

# 6.0.27 (2022-05-10)

## Bug fixes

- PIM-10425: Fix notifications can't be displayed because of removed routes

## Improvements

- Use Node v14 in docker-compose files

# 6.0.26 (2022-04-29)

# 6.0.25 (2022-04-14)

# 6.0.24 (2022-04-13)

## Bug fixes

- PIM-10332: [Backport PIM-10331] Fix error when using an association with quantities having an numeric code

# 6.0.23 (2022-04-11)

# 6.0.22 (2022-04-08)

# 6.0.21 (2022-04-06)

## Bug fixes

- PIM-10324: [Backport PIM-10232] Fix "A new entity is found through the relationship" errors in jobs
- PIM-10385: Fix message "New patch available" is present even if the PIM on the last patch

# 6.0.20 (2022-04-01)

## Bug fixes

- PIM-10323: [Backport PIM-10233] Fix the saved value by an empty wysiwyg

# 6.0.19 (2022-03-28)

- PIM-10369: Fix deprecated migrations present during Standard-Edition upgrade

# 6.0.18 (2022-03-24)

# 6.0.17 (2022-03-24)

# 6.0.16 (2022-03-24)

## Bug fixes
- PIM-10325: [Backport PIM-10229] Enforce strict samesite policy for session cookies
- PIM-10321: [Backport PIM-10241] Fix user account disabled can connect regression

# 6.0.15 (2022-03-23)

# 6.0.14 (2022-03-22)

# 6.0.13 (2022-03-18)

# 6.0.12 (2022-03-17)

## Improvement
- Fix Docker Composer cache

# 6.0.11 (2022-03-16)

# 6.0.10 (2022-03-14)

# 6.0.9 (2022-03-14)

# 6.0.8 (2022-03-11)

## Bug fixes
- PLG-776: Fix Option page broken issue with small screen when creating a new option
- PIM-10305: Do not allow disabled user to login
- PLG-781: Fix migration task related to calculating product quality scores to be independent of the JobExecution implementation
- RAC-1223: [Backport] RAC-1215: fix error when attributeOption doesn't have label
- PIM-10308: [Backport PIM-10292] Fix error 500 when role page contain a validation errors
- PIM-10315: [Backport PIM-10264] Optimize variant product ratio query
- PIM-10318: [Backport PIM-10259] Add ArPHP library and fix Arabic RTL in PDF Exports

# 6.0.7 (2022-02-25)

# 6.0.6 (2022-02-21)

# 6.0.5 (2022-02-17)

## Bug fixes

- PIM-10287: Fix deprecated methods for Symfony\Component\Console\Helper\TableStyle
- BH-986: Add missing migration file for standard.

# 6.0.4 (2022-02-10)

# 6.0.3 (2022-02-09)

# 6.0.2 (2022-02-09)

# 6.0.1 (2022-02-07)

# 6.0.0 (2022-02-04)

## Bug fixes

- PIM-10005: New Product API Web Permission migration didn't work properly
- PIM-9946: Throw warning when product import contains two products with same identifiers
- PIM-9885: Associating a product to itself with a 2-way association returns an error 500
- PIM-9890: Creating Channels with numeric code breaks the PIM
- PIM-9748: Upgrade JQuery for security reasons
- PIM-9678: The time counter is still running despite the job failed
- PIM-9672: Error 500 on the API when inputing [null] on an array
- PIM-9595: Avoid 403 error when launching import with no view rights on import details
- PIM-9622: Fix query that can generate a MySQL memory allocation error
- PIM-9630: Fix SQL sort buffer size issue when the catalog has a very large number of categories
- PIM-9636: Fix add posibility to contextualize translation when create a variant depending on number of axes
- PIM-9631: fix attribute groups not displayed in family due to JS error
- PIM-9649: Fix PDF product renderer disregarding permissions on Attribute groups
- PIM-9650: Add translation key for mass delete action.
- PIM-9642: Refresh product image when switching channel or locale
- PIM-9667: Prevent import of duplicate options in multiselect attributes
- PIM-9658: Add missing backend permission checks
- PIM 9657: Make open filters close when opening a new one.
- PIM-9671: Provide a data quality insight status context for attribute groups
- PIM-9670: Fix attribute filter "Group" issue when several attribute groups have the same label
- PIM-9664: Display Ziggy as asset image when the preview cannot be generated
- PIM-9681: Fix criteria selector closing behavior on the product grid filters
- PIM-9686: Fix memory leak during "set_attribute_requirements" job
- PIM-9690: Fix job remaining in stopping status forever
- PIM-9700: Add batch-size option in index products command and index product-models command
- PIM-9701: Fix role deletion when a user do not have any role
- PIM-9699: Fix clicking detail on last operation return 404 on import and export jobs
- API-1483: Fix the test button of the Event Subscription
- PLG-63: Fix product-grid grouped variant filter dropdown
- PIM-9718: Decimals attribute values with no separators are well formatted
- PIM-9727: Add missing query params to hatoas links
- API-9698: Refresh ES index after creating a product from the UI in order to well send product created event to event subscriptions
- PIM-9711: Check that a category root isn't linked to a user or a channel before moving it to a sub-category
- PIM-9730: Fix category tree initialization in the PEF when switching tabs
- PIM-9679: Clean existing text attribute values removing linebreaks
- PIM-9758: Fix bad replacement for line breaks introduced in PIM-9658
- PIM-9743: Add the "change input" event so that the SKU/code doesn't disappear when doing copy/paste
- PIM-9759: Fix step name translation for product models csv import
- PIM-9740: Prevent to delete a channel used in a product export job
- PIM-9764: Fix DSM Card component to handle links properly
- PIM-9773: Fix unique variant axis validator considering 01 and 1 as equal
- PIM-9767: Fix minimum & maximum user password validation
- PIM-9765: Fix missing translation key in bulk actions when adding attributes values for some product
- PIM-9780: Fix completed import/export job notification broken link
- PIM-9783: Optimize batch query when compute completeness
- PIM-9783: Optimize SQL query when compute completeness
- PIM-9715: Prevent the deletion of an attribute used as a label by a family
- PIM-9781: Fix Category tree not refreshing when switching locale
- PIM-9779: Fix ACE order when loading ACLs
- PIM-9739: Fix connection users, users, channels having a link to a sub-category
- PIM-9763: Make sure that 2 users can each create a private view with the same name
- PIM-9798: Refresh completeness on product grid after family import
- PIM-9800: Fix event not sent issue when creating products or product models
- PIM-9809: Fix missing filters in the product grid for few UI locales with Firefox
- PIM-9807: Trigger warning when importing date as text attribute via XLSX files
- PIM-9801: Fix jobs that are still stuck in STARTED and STOPPING and create a command to avoid this again
- PIM-9771: Fix the image preview when exporting a product as pdf
- PIM-9829: Fix product grid crash when using a family filter on a deleted family
- PIM-9820: Fix the Error 500 on the product grid with the date filter
- PIM-9833: Fix null pointer exception on Product::getVariationLevel (CE contribution)
- PIM-9826: Display the system attribute filters with the UI locale on the user account settings
- PIM-9834: Fix MySQL error when trying to import new attribute options to attributes with a lot of options already
- PIM-9850: Fix broken section title in DQI dashboard
- PIM-9827: Fix HTTP 500 when using POST/PATCH with incorrect format
- PIM-9857: Fix Microgram & Microliter conversion operations
- PIM-9856: Fix children completeness query being too long
- PIM-9853: Make the word "product" translatable
- PIM-9741: Fix choice filter mask not closing when selecting with keyboard
- PIM-9806: Enable authentication temporary lock to protect against brute force attack
- PIM-9864: Fix 500 error when using DateTime filter with invalid value
- PIM-9869: Fix download log in job tracker is only available when log is located in the fpm server
- PIM-9777: Fix error message when trying to delete an attribute linked to an entity
- PIM-9873: Fix since last n day filter in product export
- PIM-9852: Fix exception during PRE_REMOVE on removeAll cause ES desynchronisation
- PIM-9876: Fix purge of products old scores in Data Quality Insights
- PIM-9881: Do not update a product value which was not modified
- PIM-9863: Remove temporisation and add unit tests for product model reindexation.
- PIM-9891: Fix missing sanity checks when computing enrichment status
- PIM-9886: Fix display of completeness in the PEF when the selected locale is deactivated
- PIM-9925: Fix roles that couldn't contain dashes in their codes
- PIM-9933: Fix delete category menu that stays displayed on screen
- PIM-9949: Fix category edit page to use catalog locale
- PIM-9950: Fix import product model fail instead of warning vs permission
- PIM-9948: Fix performance issue on product model import
- PIM-9966: Fix Settings page crashing when coming from the PEF
- PIM-9973: Fix Asset attribute media type dropdown being hidden
- PIM-9986: Fix error message returned by the backend not displayed when an error occured while deleting a category
- PIM-9942: Fix message on DQI dashboard in French UI locale
- PIM-9947: Display validation errors message in the UI when `compute_family_variant_structure_changes` job fails
- PIM-9987: Fix product grid count not accurate after specific SKU selection
- PIM-10009: Fix error being printed in the response of partial update of product models API
- PIM-10003: Fix translation in setting page are not plurializable
- PIM-9989: Fix record code of reference entity field is case-sensitive
- PIM-10026: Avoid session persistance for API
- PIM-9997: Fix page freezing after deleting a user group
- PIM-10019: Update product indexation on attribute as label change
- PIM-10037: Fix family variant query to return correct number of results
- PIM-10041: Change configuration to apply APP_ELASTICSEARCH_TOTAL_FIELDS_LIMIT to assets and references entities
- PIM-9990: Fix lost of keyup event when tab key is pressed too fast on input field
- CXP-838: Fix (Not)LocalizableAnd(Not)ScopableAttributeException catches
- PIM-10029: Added an explicit class named container to inject additional content into sub-navigation panel
- PIM-10067: Date value in calendar not set when none is selected
- PIM-10071: Fix fatal error in case of Cursor::getResults is called without been initialized
- PIM-10077: Fix the "product image" filter display (untranslatable values on languages other than english)
- PIM-10078: Add sanity check on attribute options to avoid having an empty screen.
- PIM-10085: Fix product grid filters with multiple selectable values going out of screen when too many values are selected
- PIM-10074: Add translation key for mass action selection
- PIM-10062: Suppress PHP warning when missing 'dataScope' value.
- Bump NodeJS library to fix CVE on tmpl 1.0.4
- CVE-2021-3777: Bump tmpl from 1.0.4 to 1.0.5
- CVE-2021-23343: Bump path-parse from 1.0.6 to 1.0.7
- GHSA-6fc8-4gx4-v693: Bump ws from 7.4.5 to 7.5.5
- PIM-10096: Reload PEF main image on channel switching
- CVE-2021-23368: Bump postcss from 7.0.35 to 7.0.36
- CVE-2021-23358: Bump underscore from 1.8.3 to 1.12.1
- GHSA-6fc8-4gx4-v693: Bump ws from 7.4.5 to 7.5.5 (yarn.lock and front-packages/share/yarn.lock)
- CVE-2021-23364: Bump browserslist from 4.16.4 to 4.16.6 in /front-packages/shared
- PIM-10095: Fix API error when providing an integer for the identifier or code when patching products or models
- CVE-2021-3807: Bump ansi-regex from 5.0.0 to 5.0.1 in /front-packages/shared
- CVE-2021-23343: Bump path-parse from 1.0.6 to 1.0.7 in /front-packages/shared
- PIM-10094: Increase product grid filters limit display in user settings
- PIM-10101: Fix incorrect count of families selection in the family grid
- PIM-10107: Hide add quantified association button when ACL is not granted
- PIM-10100: Added a product & product model indexation step for setAttributeRequirements job
- PIM-10092: Display an error message when trying to delete a category tree linked to a channel
- PIM-10116: Fix filter bar not being sticky on Measurement & Attribute groups page
- PIM-10030: use POST method to fetch product data grid data to avoid http 414 error
- EXB-1046: Don't delete a channel used in an "Export to Shared Catalogs" export profile
- PIM-10087: Fix storage errors HTTP code to return 500 instead of 422
- PIM-10090: Fix missing cache clearing during family variant changes computing
- PIM-10048: fix memory leak in search product models by family variant query
- PIM-10115: Connections domain blacklist should deny local ip
- PIM-10138: Fix Add attribute dropdown being hidden when bulk editing Assets
- PIM-10129: Fix error 414 with a long filter list when launching a bulk action and quick export
- PIM-10139: Fix missing translation key in Italian locale with "change family" mass action
- PIM-10145: Fix reset password page
- PIM-10163: Prefix groups breadcrumb link to avoid 404
- PIM-10160: Fix AM thumbnail generation when filename is longer than 100 characters
- PIM-10167: Fix import file - datetime in price attribute break the import
- PIM-10177: Fix warning level for status badge on last operations
- PIM-10158: Fix failed migration longtext to json for akeneo_batch_job_execution.raw_parameters du to empty values
- PIM-10187: Fix impossible to configure the columns of the product grid if attribute labels are too long
- PIM-10155: Decrease batch size during indexation of products and product models
- PIM-10182: Search_after uses identifiers/codes instead of encrypted Mysql ids in external API
- PIM-10149: Fix group product page OOM (remove group to products association)
- PIM-10193: fix TypeError(implode(): Argument #2 () must be of type ?array, string given)
- PIM-10194: Fix pagination for list products/product models endpoints with search_after pagination type
- PIM-10199: Fix occasional segmentation fault when generating thumbnails
- PIM-10198: Fixed error message display when saving family variant
- PIM-10206: Fix product and product model save when they had values for a deleted channel or locale
- PIM-10197: Added safeguards against attribute change to locale specific when the same attribute is a variant axis for a family
- PIM-10208: Fix currency settings page crashing when label is not found
- PIM-10192: Retry mechanism in delete action of ES documents
- PIM-10214: Fix cannot create a measurement attribute if measurement family or unit code is too long
- PIM-10210: Fix notifications can't be displayed
- PIM-10220: Fixed issues where association has NaN error
- PIM-10217: Fix cannot quick export product model when id is not present in grid context
- PIM-10212: Prevent spaces in locale codes
- PIM-10218: Remove previous scope filter before moving the new one
- PIM-11008: [Backport PIM-10960] Fix no violation raised when importing variant with already existing siblings

## New features

- DAPI-1443: Add possibility to export products depending on their Quality Score
- DAPI-1480: Add possibility to filter products on Quality Score through the API

## Improvements

- PIM-9716: Autoselect last element of pasted list in choice filter
- PIM-9985: Improve channels sentence display in the settings menu

# Technical Improvements

- PIM-9648: Mitigate DDoS risk on API auth endpoint by rejecting too large content
- PIM-9697: Exported files streamer
- PIM-9719: Add the real "updated" values in ES for product and product models
- CPM-152: Use Symfony Messenger to handle job queue messages. Therefore the `akeneo_batch_job_execution_queue` table is removed.
  Depending on your environment, please check the associated `messenger.yml` to figure out how the messages are sent/received.
  The former command to launch job consumption is removed and replaced by:

```bash
bin/console messenger:consume ui_job import_export_job data_maintenance_job
```

- PIM-9929: Improve performances of attribute options list PATCH endpoint when Data Quality Insights is enabled
- PIM-9877: Optimize DQI dashboard data consolidation
- PIM-10004: Optimize counting job execution warnings
- PIM-10142: Block HTTP redirection in Webhook URLs
- PIM-10144: Don't display Guzzle version in user agent
- PIM-10098: Add a command/handler to remove a product model

## Classes

## BC Breaks

- CPM-101: Remove twig/extensions dependency (abandoned)
- CPM-100: replace deprecated `Symfony\Component\Translation\TranslatorInterface` by `Symfony\Contracts\Translation\TranslatorInterface`
- CPM-100: replace deprecated `Symfony\Component\HttpKernel\Event\GetResponseEvent` by `Symfony\Component\HttpKernel\Event\RequestEvent`

### Codebase

- Change constructor of `Oro\Bundle\PimDataGridBundle\Controller\DatagridController` to remove `Symfony\Bundle\FrameworkBundle\Templating\EngineInterface $templating`
- Change constructor of `Oro\Bundle\FilterBundle\Form\Type\Filter\DateTimeRangeFilterType` to remove `Symfony\Component\Translation\TranslatorInterface $translator`
- Change constructor of `Oro\Bundle\PimFilterBundle\Filter\ProductValue\MetricFilter` to remove `Symfony\Component\Translation\TranslatorInterface $translator`
- Change constructor of `Akeneo\Pim\Enrichment\Component\Product\Normalizer\InternalApi\VersionNormalizer` to add `Symfony\Contracts\Translation\LocaleAwareInterface\LocaleAwareInterface $localeAware`
- Change constructor of `Akeneo\UserManagement\Bundle\EventListener\LocaleSubscriber` to:
  - remove `Symfony\Component\Translation\TranslatorInterface $translator`
  - add `Symfony\Contracts\Translation\LocaleAwareInterface\LocaleAwareInterface $localeAware`

### CLI commands

- PIM-9738: Remove command pim:catalog:remove-completeness-for-channel-and-locale

### Services
