<?php

declare(strict_types=1);

namespace Pim\Upgrade\Schema;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

final class Version_6_0_20211122154203_add_step_count_in_job_execution extends AbstractMigration
{
    private const STEP_COUNT_MAP = [
        0 => ['akeneo_shared_catalog'],
        1 => [
            'csv_user_group_export',
            'xlsx_user_group_export',
            'csv_user_role_export',
            'xlsx_user_role_export',
            'csv_user_export',
            'xlsx_user_export',
            'csv_locale_export',
            'xlsx_locale_export',
            'csv_channel_export',
            'xlsx_channel_export',
            'csv_currency_export',
            'xlsx_currency_export',
            'compute_completeness_of_products_family',
            'remove_completeness_for_channel_and_locale',
            'compute_family_variant_structure_changes',
            'csv_group_export',
            'csv_product_export',
            'csv_product_model_export',
            'xlsx_product_export',
            'xlsx_product_model_export',
            'csv_category_export',
            'xlsx_category_export',
            'xlsx_group_export',
            'add_to_group',
            'add_association',
            'add_to_existing_product_model',
            'convert_to_simple_products',
            'delete_products_and_product_models',
            'change_parent_product',
            'remove_non_existing_product_values',
            'csv_attribute_export',
            'csv_attribute_option_export',
            'csv_attribute_group_export',
            'xlsx_attribute_export',
            'xlsx_attribute_option_export',
            'xlsx_attribute_group_export',
            'csv_association_type_export',
            'xlsx_association_type_export',
            'csv_family_export',
            'csv_family_variant_export',
            'xlsx_family_export',
            'xlsx_family_variant_export',
            'csv_group_type_export',
            'xlsx_group_type_export',
            'data_quality_insights_recompute_products_scores',
            'csv_table_attribute_options_export',
            'xlsx_table_attribute_options_export',
            'yml_rule_import',
            'yml_rule_export',
            'rule_impacted_product_count',
            'rule_engine_execute_rules',
            'csv_reference_entity_record_export',
            'xlsx_reference_entity_record_export',
            'reference_entity_mass_delete_records',
            'fixtures_attribute_group_access_csv',
            'fixtures_product_category_access_csv',
            'fixtures_job_profile_access_csv',
            'fixtures_locale_access_csv',
            'fixtures_rule_yml',
            'refresh_project_completeness_calculation',
            'csv_product_proposal_import',
            'csv_product_model_proposal_import',
            'csv_published_product_export',
            'xlsx_product_proposal_import',
            'xlsx_product_model_proposal_import',
            'xlsx_published_product_export',
            'approve_product_draft',
            'refuse_product_draft',
            'csv_published_product_quick_export',
            'csv_published_product_grid_context_quick_export',
            'xlsx_published_product_quick_export',
            'xlsx_published_product_grid_context_quick_export',
            'publish_product',
            'unpublish_product',
            'asset_manager_link_assets_to_products',
            'asset_manager_execute_naming_convention',
            'asset_manager_compute_transformations',
            'asset_manager_mass_delete_assets',
            'asset_manager_mass_edit_assets',
            'asset_manager_csv_asset_export',
            'asset_manager_xlsx_asset_export',
            'xlsx_tailored_product_export',
            'csv_tailored_product_export',
            'xlsx_tailored_product_model_export',
            'csv_tailored_product_model_export',
        ],
        2 => [
            'csv_user_group_import',
            'xlsx_user_group_import',
            'csv_user_import',
            'csv_user_role_import',
            'xlsx_user_import',
            'xlsx_user_role_import',
            'csv_locale_import',
            'xlsx_locale_import',
            'csv_channel_import',
            'xlsx_channel_import',
            'csv_currency_import',
            'xlsx_currency_import',
            'csv_group_import',
            'csv_category_import',
            'xlsx_category_import',
            'xlsx_group_import',
            'csv_product_quick_export',
            'csv_product_grid_context_quick_export',
            'xlsx_product_quick_export',
            'xlsx_product_grid_context_quick_export',
            'update_product_value',
            'add_product_value',
            'remove_product_value',
            'move_to_category',
            'add_to_category',
            'remove_from_category',
            'csv_attribute_import',
            'csv_attribute_option_import',
            'xlsx_attribute_import',
            'xlsx_attribute_option_import',
            'xlsx_attribute_group_import',
            'csv_association_type_import',
            'xlsx_association_type_import',
            'csv_family_variant_import',
            'xlsx_family_variant_import',
            'csv_group_type_import',
            'xlsx_group_type_import',
            'fixtures_category_csv',
            'fixtures_attribute_group_csv',
            'fixtures_channel_csv',
            'fixtures_locale_csv',
            'fixtures_currency_csv',
            'fixtures_group_type_csv',
            'fixtures_association_type_csv',
            'fixtures_attribute_csv',
            'fixtures_attribute_options_csv',
            'fixtures_family_csv',
            'fixtures_family_variant_csv',
            'fixtures_user_csv',
            'fixtures_user_role_csv',
            'fixtures_user_group_csv',
            'fixtures_group_csv',
            'fixtures_job_yml',
            'data_quality_insights_prepare_evaluations',
            'csv_table_attribute_options_import',
            'xlsx_table_attribute_options_import',
            'csv_reference_entity_record_import',
            'xlsx_reference_entity_record_import',
            'asset_manager_csv_asset_import',
            'asset_manager_xlsx_asset_import',
            'csv_supplier_import',
            'xlsx_supplier_import',
            'csv_supplier_user_import',
            'xlsx_supplier_user_import',
        ],
        3 => [
            'csv_product_import',
            'xlsx_product_import',
            'add_attribute_value',
            'csv_attribute_group_import',
            'set_attribute_requirements',
            'fixtures_product_model_csv',
            'fixtures_product_csv',
            'data_quality_insights_periodic_tasks',
        ],
        4 => [
            'csv_product_model_import',
            'xlsx_product_model_import',
            'edit_common_attributes',
            'data_quality_insights_evaluations',
            'csv_product_import_with_rules',
            'xlsx_product_import_with_rules',
        ],
        5 => [
            'clean_removed_attribute_job',
            'csv_family_import',
            'xlsx_family_import',
            'csv_product_model_import_with_rules',
            'xlsx_product_model_import_with_rules',
            'project_calculation',
        ],
    ];

    public function up(Schema $schema): void
    {
        if ($schema->getTable('akeneo_batch_job_execution')->hasColumn('step_count')) {
            $this->write('step_count column already exists in akeneo_batch_job_execution');

            return;
        }

        $this->addSql('ALTER TABLE akeneo_batch_job_execution ADD step_count INT DEFAULT 1');

        foreach (self::STEP_COUNT_MAP as $stepCount => $jobNames) {
            $this->addSql(
                sprintf(
                    'UPDATE akeneo_batch_job_execution SET step_count = %d WHERE job_instance_id IN (SELECT id FROM akeneo_batch_job_instance WHERE code IN ("%s"));',
                    $stepCount,
                    implode('", "', $jobNames),
                ),
            );
        }
    }

    public function down(Schema $schema): void
    {
        $this->throwIrreversibleMigrationException();
    }
}
